<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if (!is_a($product, WC_Product::class) || !$product->is_visible()) {
	return;
}

// Grid variables

if (!is_singular('product')) {

	// User defined style
	$columns = get_theme_mod('calafate_shop_columns', '3');
	$portfolio_type = get_theme_mod('calafate_shop_style', 'Flexible');
	$portfolio_aspect_ratio = get_theme_mod('calafate_shop_aspect_ratio', '4:3');
	$portfolio_aspect_ratio = explode(':', $portfolio_aspect_ratio);

} else {

	// Related style
	$columns = 3;
	$portfolio_type = 'Regular';
	$portfolio_aspect_ratio = array(1, 1);

}

$project_size = calafate_get_field('project-size') ? calafate_get_field('project-size') : 1;
if ($project_size > $columns)
	$project_size = $columns;
if ($portfolio_type != 'Flexible')
	$project_size = 1;

?>
<article id="post-<?php the_ID(); ?>" <?php wc_product_class('entry-portfolio uninit ' . calafate_categories($post->ID, 'product_cat', ' ', 'slug', false) . ' hover-' . get_theme_mod('calafate_shop_hover', 'one'), $product); ?>
	data-size="<?php echo $project_size; ?>">

	<?php // We decided to remove all hooks because we don't want any plugin to play with our theme's design. ?>

	<figure class="entry-thumbnail">

		<?php

		if (has_post_thumbnail()) {
			$image = wp_get_attachment_url(get_post_thumbnail_id());
			$img = calafate_portfolio_images($portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image);
		} else {
			$image = get_template_directory_uri() . '/images/blank-product.jpg';
			$img = calafate_portfolio_images($portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image, 1600, 1600);
		}

		?>

		<div class="entry-thumbnail-holder" style="padding-top: <?php echo floatval($img[2]); ?>%"
			data-padding="<?php echo floatval($img[2]); ?>">

			<img class="primary lazyload" data-srcset="<?php echo esc_attr($img[0]); ?>"
				srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"
				src="<?php echo esc_url($img[1]); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>"
				title="<?php the_title_attribute(); ?>" data-sizes="auto" />

			<?php

			$image = wp_get_attachment_url(get_post_meta($post->ID, 'product_featured-thumbnail-secondary_thumbnail_id', true));

			if (isset($image) && $image != ''):

				$img = calafate_portfolio_images($portfolio_type, $portfolio_aspect_ratio, $project_size, $columns, $image);

				?>

				<img class="secondary lazyload" data-srcset="<?php echo esc_attr($img[0]); ?>"
					srcset="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"
					src="<?php echo esc_url($img[1]); ?>" itemprop="image" alt="<?php the_title_attribute(); ?>"
					title="<?php the_title_attribute(); ?>" data-sizes="auto" />

			<?php endif;

			?>

		</div>

	</figure>

	<div class="entry-info">

		<a class="entry-title poppins ajax-link" href="<?php the_permalink(); ?>">
			<?php do_action('woocommerce_shop_loop_item_title'); ?>
			<?php echo calafate_output_hero_header_image_for_preload($post->ID); ?>
		</a>

		<span><?php wc_get_template('loop/price.php'); ?></span>

		<div class="entry-buttons">

			<?php echo apply_filters(
				'woocommerce_loop_add_to_cart_link',
				sprintf(
					'<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="add-to-cart-style %s %s product_type_%s" data-product_title="%s">%s</a>',
					esc_url($product->add_to_cart_url()),
					esc_attr($product->get_id()),
					esc_attr($product->get_sku()),
					$product->is_purchasable() ? 'add_to_cart_button' : '',
					$product->is_type('variable') ? 'ajax-link' : 'ajax-add-to-cart ajax_add_to_cart',
					esc_attr($product->get_type()),
					esc_attr(get_the_title($product->get_id())),
					calafate_svg('cross', 'before_add') . calafate_svg('loading', 'while_add') . calafate_svg('check', 'after_add')
				),
				$product
			); ?>

			<a class="ajax-link" href="<?php the_permalink(); ?>"><?php echo calafate_svg('eye'); ?></a>

		</div>

	</div>

</article>